/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.MethodWriterImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.TagletOutputImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.SerializedFormWriter;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletManager;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;

public class HtmlSerialMethodWriter
extends MethodWriterImpl
implements SerializedFormWriter.SerialMethodWriter {
    public HtmlSerialMethodWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public Content getSerializableMethodsHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    public Content getMethodsContentHeader(boolean isLastContent) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        if (isLastContent) {
            li.addStyle(HtmlStyle.blockListLast);
        } else {
            li.addStyle(HtmlStyle.blockList);
        }
        return li;
    }

    public Content getSerializableMethods(String heading, Content serializableMethodContent) {
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, this.writer.getMarkerAnchor("serialized_methods"));
        StringContent headingContent = new StringContent(heading);
        HtmlTree serialHeading = HtmlTree.HEADING(HtmlConstants.SERIALIZED_MEMBER_HEADING, headingContent);
        ((Content)li).addContent(serialHeading);
        ((Content)li).addContent(serializableMethodContent);
        return li;
    }

    public Content getNoCustomizationMsg(String msg) {
        StringContent noCustomizationMsg = new StringContent(msg);
        return noCustomizationMsg;
    }

    public void addMemberHeader(MethodDoc member, Content methodsContentTree) {
        methodsContentTree.addContent(this.writer.getMarkerAnchor(this.writer.getAnchor((ExecutableMemberDoc)member)));
        methodsContentTree.addContent(this.getHead((MemberDoc)member));
        methodsContentTree.addContent(this.getSignature(member));
    }

    public void addDeprecatedMemberInfo(MethodDoc member, Content methodsContentTree) {
        this.addDeprecatedInfo((ProgramElementDoc)member, methodsContentTree);
    }

    public void addMemberDescription(MethodDoc member, Content methodsContentTree) {
        this.addComment((ProgramElementDoc)member, methodsContentTree);
    }

    public void addMemberTags(MethodDoc member, Content methodsContentTree) {
        TagletOutputImpl output = new TagletOutputImpl("");
        TagletManager tagletManager = ConfigurationImpl.getInstance().tagletManager;
        TagletWriter.genTagOuput(tagletManager, (Doc)member, tagletManager.getSerializedFormTags(), this.writer.getTagletWriterInstance(false), output);
        String outputString = output.toString().trim();
        HtmlTree dlTags = new HtmlTree(HtmlTag.DL);
        if (!outputString.isEmpty()) {
            RawHtml tagContent = new RawHtml(outputString);
            ((Content)dlTags).addContent(tagContent);
        }
        methodsContentTree.addContent(dlTags);
        MethodDoc method = member;
        if (method.name().compareTo("writeExternal") == 0 && method.tags("serialData").length == 0) {
            this.serialWarning(member.position(), "doclet.MissingSerialDataTag", method.containingClass().qualifiedName(), method.name());
        }
    }

    protected void printTypeLinkNoDimension(Type type) {
        ClassDoc cd = type.asClassDoc();
        if (type.isPrimitive() || cd.isPackagePrivate()) {
            this.print(type.typeName());
        } else {
            this.writer.printLink(new LinkInfoImpl(8, type));
        }
    }
}

