/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import com.sun.javafx.scene.control.skin.Utils;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableCell;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class TableColumn<S, T>
implements EventTarget {
    private static final double DEFAULT_WIDTH = 80.0;
    private static final double DEFAULT_MIN_WIDTH = 10.0;
    private static final double DEFAULT_MAX_WIDTH = 5000.0;
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_COMMIT");
    public static final Callback<TableColumn<?, ?>, TableCell<?, ?>> DEFAULT_CELL_FACTORY = new Callback<TableColumn<?, ?>, TableCell<?, ?>>(){

        @Override
        public TableCell<?, ?> call(TableColumn<?, ?> tableColumn) {
            return new TableCell(){

                @Override
                protected void updateItem(Object object, boolean bl) {
                    if (object == this.getItem()) {
                        return;
                    }
                    super.updateItem(object, bl);
                    if (object == null) {
                        super.setText(null);
                        super.setGraphic(null);
                    } else if (object instanceof Node) {
                        super.setText(null);
                        super.setGraphic((Node)object);
                    } else {
                        super.setText(object.toString());
                        super.setGraphic(null);
                    }
                }
            };
        }
    };
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Comparable) {
                return ((Comparable)object).compareTo(object2);
            }
            return Collator.getInstance().compare(object.toString(), object2.toString());
        }
    };
    private EventHandler<CellEditEvent<S, T>> DEFAULT_EDIT_COMMIT_HANDLER = new EventHandler<CellEditEvent<S, T>>(){

        @Override
        public void handle(CellEditEvent<S, T> cellEditEvent) {
            int n = cellEditEvent.getTablePosition().getRow();
            ObservableList observableList = cellEditEvent.getTableView().getItems();
            if (observableList == null || n < 0 || n >= observableList.size()) {
                return;
            }
            Object e = observableList.get(n);
            ObservableValue observableValue = TableColumn.this.getCellObservableValue(e);
            if (observableValue instanceof WritableValue) {
                ((WritableValue)((Object)observableValue)).setValue(cellEditEvent.getNewValue());
            }
        }
    };
    private ListChangeListener columnsListener = new ListChangeListener<TableColumn<S, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<S, ?>> change) {
            while (change.next()) {
                for (TableColumn tableColumn : change.getRemoved()) {
                    if (TableColumn.this.getColumns().contains(tableColumn)) continue;
                    tableColumn.setTableView(null);
                    tableColumn.setParentColumn(null);
                }
                for (TableColumn tableColumn : change.getAddedSubList()) {
                    tableColumn.setTableView(TableColumn.this.getTableView());
                    tableColumn.setVisible(TableColumn.this.isVisible());
                }
                if (TableColumn.this.getColumns().isEmpty()) continue;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (TableColumn tableColumn : TableColumn.this.getColumns()) {
                    tableColumn.setParentColumn(TableColumn.this);
                    d += tableColumn.getMinWidth();
                    d2 += tableColumn.getPrefWidth();
                    d3 += tableColumn.getMaxWidth();
                }
                TableColumn.this.setMinWidth(d);
                TableColumn.this.setPrefWidth(d2);
                TableColumn.this.setMaxWidth(d3);
            }
        }
    };
    private WeakListChangeListener weakColumnsListener = new WeakListChangeListener(this.columnsListener);
    private final ObservableList<TableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private ReadOnlyObjectWrapper<TableView<S>> tableView = new ReadOnlyObjectWrapper(this, "tableView");
    private StringProperty text = new SimpleStringProperty(this, "text", "");
    private BooleanProperty visible = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            for (TableColumn tableColumn : TableColumn.this.getColumns()) {
                tableColumn.setVisible(TableColumn.this.isVisible());
            }
        }

        @Override
        public Object getBean() {
            return TableColumn.this;
        }

        @Override
        public String getName() {
            return "visible";
        }
    };
    private ReadOnlyObjectWrapper<TableColumn<S, ?>> parentColumn;
    private ObjectProperty<ContextMenu> contextMenu;
    private ObjectProperty<Callback<CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactory;
    private final ObjectProperty<Callback<TableColumn<S, T>, TableCell<S, T>>> cellFactory = new SimpleObjectProperty(this, "cellFactory", DEFAULT_CELL_FACTORY);
    private StringProperty id;
    private StringProperty style;
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    private ObjectProperty<Node> graphic;
    private ObjectProperty<Node> sortNode = new SimpleObjectProperty<Node>(this, "sortNode");
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper(this, "width", 80.0);
    private DoubleProperty minWidth;
    private final DoubleProperty prefWidth = new DoublePropertyBase(80.0){

        @Override
        protected void invalidated() {
            TableColumn.this.impl_setWidth(TableColumn.this.getPrefWidth());
        }

        @Override
        public Object getBean() {
            return TableColumn.this;
        }

        @Override
        public String getName() {
            return "prefWidth";
        }
    };
    private DoubleProperty maxWidth = new DoublePropertyBase(5000.0){

        @Override
        protected void invalidated() {
            TableColumn.this.impl_setWidth(TableColumn.this.getWidth());
        }

        @Override
        public Object getBean() {
            return TableColumn.this;
        }

        @Override
        public String getName() {
            return "maxWidth";
        }
    };
    private BooleanProperty resizable;
    private ObjectProperty<SortType> sortType;
    private BooleanProperty sortable;
    private ObjectProperty<Comparator<T>> comparator;
    private BooleanProperty editable;
    private ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditStart;
    private ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCommit = new ObjectPropertyBase<EventHandler<CellEditEvent<S, T>>>(){

        @Override
        protected void invalidated() {
            TableColumn.this.eventHandlerManager.setEventHandler(TableColumn.editCommitEvent(), (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return TableColumn.this;
        }

        @Override
        public String getName() {
            return "onEditCommit";
        }
    };
    private ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCancel;
    private static final Object USER_DATA_KEY = new Object();
    private ObservableMap<Object, Object> properties;
    private static final String DEFAULT_STYLE_CLASS = "table-column";
    @Deprecated
    protected Styleable styleable;

    public static <S, T> EventType<CellEditEvent<S, T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <S, T> EventType<CellEditEvent<S, T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <S, T> EventType<CellEditEvent<S, T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <S, T> EventType<CellEditEvent<S, T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public TableColumn() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setOnEditCommit(this.DEFAULT_EDIT_COMMIT_HANDLER);
        this.getColumns().addListener(this.weakColumnsListener);
        this.tableViewProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                for (TableColumn tableColumn : TableColumn.this.getColumns()) {
                    tableColumn.setTableView(TableColumn.this.getTableView());
                }
            }
        });
    }

    public TableColumn(String string) {
        this();
        this.setText(string);
    }

    public final ReadOnlyObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableView.getReadOnlyProperty();
    }

    final void setTableView(TableView<S> tableView) {
        this.tableView.set(tableView);
    }

    public final TableView<S> getTableView() {
        return (TableView)this.tableView.get();
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String string) {
        this.text.set(string);
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setVisible(boolean bl) {
        this.visibleProperty().set(bl);
    }

    public final boolean isVisible() {
        return this.visible.get();
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    private void setParentColumn(TableColumn<S, ?> tableColumn) {
        this.parentColumnPropertyImpl().set(tableColumn);
    }

    public final TableColumn<S, ?> getParentColumn() {
        return this.parentColumn == null ? null : (TableColumn)this.parentColumn.get();
    }

    public final ReadOnlyObjectProperty<TableColumn<S, ?>> parentColumnProperty() {
        return this.parentColumnPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableColumn<S, ?>> parentColumnPropertyImpl() {
        if (this.parentColumn == null) {
            this.parentColumn = new ReadOnlyObjectWrapper(this, "parentColumn");
        }
        return this.parentColumn;
    }

    public final void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty().set(contextMenu);
    }

    public final ContextMenu getContextMenu() {
        return this.contextMenu == null ? null : (ContextMenu)this.contextMenu.get();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        if (this.contextMenu == null) {
            this.contextMenu = new SimpleObjectProperty<ContextMenu>(this, "contextMenu");
        }
        return this.contextMenu;
    }

    public final void setCellValueFactory(Callback<CellDataFeatures<S, T>, ObservableValue<T>> callback) {
        this.cellValueFactoryProperty().set(callback);
    }

    public final Callback<CellDataFeatures<S, T>, ObservableValue<T>> getCellValueFactory() {
        return this.cellValueFactory == null ? null : (Callback)this.cellValueFactory.get();
    }

    public final ObjectProperty<Callback<CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactoryProperty() {
        if (this.cellValueFactory == null) {
            this.cellValueFactory = new SimpleObjectProperty<Callback<CellDataFeatures<S, T>, ObservableValue<T>>>(this, "cellValueFactory");
        }
        return this.cellValueFactory;
    }

    public final void setCellFactory(Callback<TableColumn<S, T>, TableCell<S, T>> callback) {
        this.cellFactory.set(callback);
    }

    public final Callback<TableColumn<S, T>, TableCell<S, T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<TableColumn<S, T>, TableCell<S, T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setId(String string) {
        this.idProperty().set(string);
    }

    public final String getId() {
        return this.id == null ? null : (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty(this, "id");
        }
        return this.id;
    }

    public final void setStyle(String string) {
        this.styleProperty().set(string);
    }

    public final String getStyle() {
        return this.style == null ? null : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty(this, "style");
        }
        return this.style;
    }

    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().set(node);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty<Node>(this, "graphic");
        }
        return this.graphic;
    }

    public final void setSortNode(Node node) {
        this.sortNodeProperty().set(node);
    }

    public final Node getSortNode() {
        return (Node)this.sortNode.get();
    }

    public final ObjectProperty<Node> sortNodeProperty() {
        return this.sortNode;
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final double getWidth() {
        return this.width.get();
    }

    private void setWidth(double d) {
        this.width.set(d);
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? 10.0 : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(10.0){

                @Override
                protected void invalidated() {
                    if (TableColumn.this.getMinWidth() < 0.0) {
                        TableColumn.this.setMinWidth(0.0);
                    }
                    TableColumn.this.impl_setWidth(TableColumn.this.getWidth());
                }

                @Override
                public Object getBean() {
                    return TableColumn.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final DoubleProperty prefWidthProperty() {
        return this.prefWidth;
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        return this.maxWidth;
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth.get();
    }

    public final BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new SimpleBooleanProperty(this, "resizable", true);
        }
        return this.resizable;
    }

    public final void setResizable(boolean bl) {
        this.resizableProperty().set(bl);
    }

    public final boolean isResizable() {
        return this.resizable == null ? true : this.resizable.get();
    }

    public final ObjectProperty<SortType> sortTypeProperty() {
        if (this.sortType == null) {
            this.sortType = new SimpleObjectProperty<SortType>(this, "sortType", SortType.ASCENDING);
        }
        return this.sortType;
    }

    public final void setSortType(SortType sortType) {
        this.sortTypeProperty().set(sortType);
    }

    public final SortType getSortType() {
        return this.sortType == null ? SortType.ASCENDING : (SortType)((Object)this.sortType.get());
    }

    public final BooleanProperty sortableProperty() {
        if (this.sortable == null) {
            this.sortable = new SimpleBooleanProperty(this, "sortable", true);
        }
        return this.sortable;
    }

    public final void setSortable(boolean bl) {
        this.sortableProperty().set(bl);
    }

    public final boolean isSortable() {
        return this.sortable == null ? true : this.sortable.get();
    }

    public final ObjectProperty<Comparator<T>> comparatorProperty() {
        if (this.comparator == null) {
            this.comparator = new SimpleObjectProperty<Comparator>(this, "comparator", DEFAULT_COMPARATOR);
        }
        return this.comparator;
    }

    public final void setComparator(Comparator<T> comparator) {
        this.comparatorProperty().set(comparator);
    }

    public final Comparator<T> getComparator() {
        return this.comparator == null ? DEFAULT_COMPARATOR : (Comparator)this.comparator.get();
    }

    public final void setEditable(boolean bl) {
        this.editableProperty().set(bl);
    }

    public final boolean isEditable() {
        return this.editable == null ? true : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", true);
        }
        return this.editable;
    }

    public final void setOnEditStart(EventHandler<CellEditEvent<S, T>> eventHandler) {
        this.onEditStartProperty().set(eventHandler);
    }

    public final EventHandler<CellEditEvent<S, T>> getOnEditStart() {
        return this.onEditStart == null ? null : (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            this.onEditStart = new ObjectPropertyBase<EventHandler<CellEditEvent<S, T>>>(){

                @Override
                protected void invalidated() {
                    TableColumn.this.eventHandlerManager.setEventHandler(TableColumn.editStartEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TableColumn.this;
                }

                @Override
                public String getName() {
                    return "onEditStart";
                }
            };
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<CellEditEvent<S, T>> eventHandler) {
        this.onEditCommit.set(eventHandler);
    }

    public final EventHandler<CellEditEvent<S, T>> getOnEditCommit() {
        return (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCommitProperty() {
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<CellEditEvent<S, T>> eventHandler) {
        this.onEditCancelProperty().set(eventHandler);
    }

    public final EventHandler<CellEditEvent<S, T>> getOnEditCancel() {
        return this.onEditCancel == null ? null : (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            this.onEditCancel = new ObjectPropertyBase<EventHandler<CellEditEvent<S, T>>>(){

                @Override
                protected void invalidated() {
                    TableColumn.this.eventHandlerManager.setEventHandler(TableColumn.editCancelEvent(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TableColumn.this;
                }

                @Override
                public String getName() {
                    return "onEditCancel";
                }
            };
        }
        return this.onEditCancel;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public final ObservableList<TableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    public final T getCellData(int n) {
        ObservableValue<T> observableValue = this.getCellObservableValue((S)n);
        return observableValue == null ? null : (T)observableValue.getValue();
    }

    public final T getCellData(S s) {
        ObservableValue<T> observableValue = this.getCellObservableValue(s);
        return observableValue == null ? null : (T)observableValue.getValue();
    }

    public final ObservableValue<T> getCellObservableValue(int n) {
        if (n < 0) {
            return null;
        }
        TableView<S> tableView = this.getTableView();
        if (tableView == null || tableView.getItems() == null) {
            return null;
        }
        ObservableList<S> observableList = tableView.getItems();
        if (n >= observableList.size()) {
            return null;
        }
        Object e = observableList.get(n);
        return this.getCellObservableValue(e);
    }

    public final ObservableValue<T> getCellObservableValue(S s) {
        Callback<CellDataFeatures<S, T>, ObservableValue<T>> callback = this.getCellValueFactory();
        if (callback == null) {
            return null;
        }
        TableView<S> tableView = this.getTableView();
        if (tableView == null) {
            return null;
        }
        CellDataFeatures cellDataFeatures = new CellDataFeatures(tableView, this, s);
        return callback.call(cellDataFeatures);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.prepend(this.eventHandlerManager);
    }

    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    @Deprecated
    public void impl_setWidth(double d) {
        this.setWidth(Utils.boundedSize(d, this.getMinWidth(), this.getMaxWidth()));
    }

    @Deprecated
    public Styleable impl_getStyleable() {
        if (this.styleable == null) {
            this.styleable = new Styleable(){

                @Override
                public String getId() {
                    return TableColumn.this.getId();
                }

                @Override
                public List<String> getStyleClass() {
                    return TableColumn.this.getStyleClass();
                }

                @Override
                public String getStyle() {
                    return TableColumn.this.getStyle();
                }

                @Override
                public Styleable getStyleableParent() {
                    return TableColumn.this.getTableView() == null ? null : TableColumn.this.getTableView().impl_getStyleable();
                }

                @Override
                public List<StyleableProperty> getStyleableProperties() {
                    return Collections.EMPTY_LIST;
                }

                @Override
                public Node getNode() {
                    if (!(TableColumn.this.getTableView().getSkin() instanceof TableViewSkin)) {
                        return null;
                    }
                    TableViewSkin tableViewSkin = (TableViewSkin)TableColumn.this.getTableView().getSkin();
                    TableHeaderRow tableHeaderRow = tableViewSkin.getTableHeaderRow();
                    NestedTableColumnHeader nestedTableColumnHeader = tableHeaderRow.getRootHeader();
                    return this.scan(nestedTableColumnHeader);
                }

                private TableColumnHeader scan(TableColumnHeader tableColumnHeader) {
                    if (TableColumn.this.equals(tableColumnHeader.getTableColumn())) {
                        return tableColumnHeader;
                    }
                    if (tableColumnHeader instanceof NestedTableColumnHeader) {
                        NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)tableColumnHeader;
                        for (int i = 0; i < nestedTableColumnHeader.getColumnHeaders().size(); ++i) {
                            TableColumnHeader tableColumnHeader2 = this.scan((TableColumnHeader)nestedTableColumnHeader.getColumnHeaders().get(i));
                            if (tableColumnHeader2 == null) continue;
                            return tableColumnHeader2;
                        }
                    }
                    return null;
                }
            };
        }
        return this.styleable;
    }

    public static class CellDataFeatures<S, T> {
        private final TableView<S> tableView;
        private final TableColumn<S, T> tableColumn;
        private final S value;

        public CellDataFeatures(TableView<S> tableView, TableColumn<S, T> tableColumn, S s) {
            this.tableView = tableView;
            this.tableColumn = tableColumn;
            this.value = s;
        }

        public S getValue() {
            return this.value;
        }

        public TableColumn<S, T> getTableColumn() {
            return this.tableColumn;
        }

        public TableView<S> getTableView() {
            return this.tableView;
        }
    }

    public static class CellEditEvent<S, T>
    extends Event {
        private final T newValue;
        private final transient TablePosition<S, T> pos;

        public CellEditEvent(TableView<S> tableView, TablePosition<S, T> tablePosition, EventType<CellEditEvent> eventType, T t) {
            super(tableView, Event.NULL_SOURCE_TARGET, eventType);
            if (tableView == null) {
                throw new NullPointerException("TableView can not be null");
            }
            if (tablePosition == null) {
                throw new NullPointerException("TablePosition can not be null");
            }
            this.pos = tablePosition;
            this.newValue = t;
        }

        public TableView<S> getTableView() {
            return this.pos.getTableView();
        }

        public TableColumn<S, T> getTableColumn() {
            return this.pos.getTableColumn();
        }

        public TablePosition<S, T> getTablePosition() {
            return this.pos;
        }

        public T getNewValue() {
            return this.newValue;
        }

        public T getOldValue() {
            S s = this.getRowValue();
            if (s == null || this.pos.getTableColumn() == null) {
                return null;
            }
            return this.pos.getTableColumn().getCellData(s);
        }

        public S getRowValue() {
            ObservableList<S> observableList = this.getTableView().getItems();
            if (observableList == null) {
                return null;
            }
            int n = this.pos.getRow();
            if (n < 0 || n >= observableList.size()) {
                return null;
            }
            return (S)observableList.get(n);
        }
    }

    public static enum SortType {
        ASCENDING,
        DESCENDING;

    }
}

