/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.components.ui.settings.TextControl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringInput
extends Input {
    private boolean m_allowEmpty = true;
    private boolean m_allowSpaces = true;
    private boolean m_readOnly = false;
    private boolean m_multiLine = false;
    private Text m_text;
    private final ModifyListener m_textListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (StringInput.this.isEnabled()) {
                Text text = (Text)e.widget;
                StringInput.this.setPropertyValue(text.getText());
                StringInput.this.markStale();
            }
        }
    };
    private TextControl m_textControl;
    private boolean m_password;

    public StringInput(String property, String name) {
        super(property, name);
    }

    public final StringInput setAllowEmpty(boolean allowEmpty) {
        this.m_allowEmpty = allowEmpty;
        return this;
    }

    public final StringInput setAllowSpace(boolean allowSpaces) {
        this.m_allowSpaces = allowSpaces;
        return this;
    }

    public final StringInput setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        return this;
    }

    public final StringInput setMultiLine(boolean multiLine) {
        this.m_multiLine = multiLine;
        return this;
    }

    public final StringInput setPassword(boolean password) {
        this.m_password = password;
        return this;
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        GridData gdLabel = new GridData(4, 4, false, false);
        gdLabel.horizontalSpan = 1;
        gdLabel.verticalAlignment = this.isMulitiLine() ? 128 : 0x1000000;
        Label label = this.createLabel(parent);
        label.setLayoutData((Object)gdLabel);
        GridData gdText = new GridData(4, 4, true, this.isMulitiLine());
        gdText.horizontalSpan = horizontalSpan - 1;
        if (this.isMulitiLine()) {
            gdText.heightHint = 200;
        }
        this.m_text = this.createText(parent);
        this.m_text.setLayoutData((Object)gdText);
        this.hookTextListener(this.m_text);
    }

    protected final boolean isMulitiLine() {
        return this.m_multiLine;
    }

    protected final Label createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        return label;
    }

    protected void createTextWithLayout(Composite parent, int span) {
        GridData gdText = new GridData(4, 4, true, this.isMulitiLine());
        gdText.horizontalSpan = span;
        this.m_text = this.createText(parent);
        this.m_text.setLayoutData((Object)gdText);
    }

    private Text createText(Composite parent) {
        this.m_textControl = new TextControl(parent, this.determineStyle());
        Text text = this.m_textControl.getControl();
        text.setEditable(!this.m_readOnly);
        text.setText("");
        text.setEnabled(false);
        return text;
    }

    private int determineStyle() {
        int style = 2048;
        if (this.m_multiLine) {
            style |= 0x202;
        }
        if (this.m_password) {
            style |= 0x400000;
        }
        return style;
    }

    @Override
    public IStatus getStatus() {
        if (!this.isReadOnly()) {
            if (this.violatesAllowEmpty()) {
                return new Status(4, "com.jrockit.mc.components.ui", Messages.STRING_INPUT_MUST_CONTAIN_AT_LEAST_ONE_CHARACTER_TEXT);
            }
            if (this.violatesAllowSpaces()) {
                return new Status(4, "com.jrockit.mc.components.ui", Messages.STRING_INPUT_SPACE_NOT_ALLOWED_TEXT);
            }
        }
        return new Status(0, "com.jrockit.mc.components.ui", Messages.STRING_INPUT_VALID_INPUT);
    }

    private boolean isReadOnly() {
        return this.m_readOnly;
    }

    private boolean violatesAllowSpaces() {
        return !this.m_allowSpaces && this.getPropertyValue().contains(" ");
    }

    private boolean violatesAllowEmpty() {
        return !this.m_allowEmpty && this.getPropertyValue().length() == 0;
    }

    protected void unhookTextListener(Text text) {
        text.removeModifyListener(this.m_textListener);
    }

    protected void hookTextListener(Text text) {
        text.addModifyListener(this.m_textListener);
    }

    @Override
    public void refresh() {
        this.m_text.setEnabled(this.isEnabled());
        if (this.isEnabled()) {
            this.m_textControl.updateControlDecoration(this.getStatus());
            String p = this.getPropertyValue();
            if (!this.m_text.getText().equals(p)) {
                this.unhookTextListener(this.m_text);
                this.m_text.setText(this.getPropertyValue());
                this.hookTextListener(this.m_text);
            }
        } else {
            this.unhookTextListener(this.m_text);
            this.m_text.setText("");
            this.hookTextListener(this.m_text);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_text.setEnabled(enabled);
    }
}

