/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.TopComponentTracker;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class ResetWindowsAction
implements ActionListener {
    private final boolean reset;

    public static ActionListener reset() {
        return new ResetWindowsAction(true);
    }

    public static ActionListener reload() {
        return new ResetWindowsAction(false);
    }

    public ResetWindowsAction(boolean bl) {
        this.reset = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
        if (null == windowSystem) {
            Logger.getLogger(ResetWindowsAction.class.getName()).log(Level.INFO, "Reset Windows action does not support custom WindowSystem implementations.");
            return;
        }
        final WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        MainWindow.getInstance().setFullScreenMode(false);
        windowManagerImpl.getMainWindow().setExtendedState(0);
        TopComponentGroupImpl topComponentGroupImpl = (TopComponentGroupImpl)windowManagerImpl.findTopComponentGroup("OpenedProjects");
        final boolean bl = null != topComponentGroupImpl && topComponentGroupImpl.isOpened();
        final TopComponent[] topComponentArray = this.collectEditors();
        windowManagerImpl.closeNonEditorViews();
        windowManagerImpl.getMainWindow().setVisible(false);
        final TopComponent topComponent = windowManagerImpl.getArbitrarySelectedEditorTopComponent();
        windowManagerImpl.deselectEditorTopComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object object;
                try {
                    object = PersistenceManager.getDefault().getRootLocalFolder();
                    if (ResetWindowsAction.this.reset && null != object) {
                        for (FileObject fileObject : object.getChildren()) {
                            if ("Components".equals(fileObject.getName())) continue;
                            fileObject.delete();
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                windowSystem.hide();
                WindowManagerImpl.getInstance().resetModel();
                PersistenceManager.getDefault().reset();
                PersistenceHandler.getDefault().clear();
                windowSystem.load();
                windowSystem.show();
                if (bl && null != (object = windowManagerImpl.findTopComponentGroup("OpenedProjects"))) {
                    object.open();
                }
                object = (ModeImpl)windowManagerImpl.findMode("editor");
                RegistryImpl registryImpl = (RegistryImpl)TopComponent.getRegistry();
                for (int i = 0; i < topComponentArray.length && null != object; ++i) {
                    ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponentArray[i]);
                    if (null == modeImpl) {
                        modeImpl = object;
                    }
                    if (null != modeImpl) {
                        modeImpl.addOpenedTopComponentNoNotify(topComponentArray[i]);
                    }
                    registryImpl.addTopComponent(topComponentArray[i]);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Frame frame = windowManagerImpl.getMainWindow();
                        frame.invalidate();
                        frame.repaint();
                    }
                });
                if (null != topComponent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            topComponent.requestActive();
                        }
                    });
                }
            }
        });
    }

    private TopComponent[] collectEditors() {
        TopComponentTracker topComponentTracker = TopComponentTracker.getDefault();
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(TopComponent.getRegistry().getOpened().size());
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode("editor");
        if (null != modeImpl) {
            for (TopComponent object : modeImpl.getOpenedTopComponents()) {
                if (topComponentTracker.isViewTopComponent(object)) continue;
                arrayList.add(object);
            }
        }
        for (ModeImpl modeImpl2 : WindowManagerImpl.getInstance().getModes()) {
            if ("editor".equals(modeImpl2.getName())) continue;
            for (TopComponent topComponent : modeImpl2.getOpenedTopComponents()) {
                if (topComponentTracker.isViewTopComponent(topComponent)) continue;
                arrayList.add(topComponent);
            }
        }
        return arrayList.toArray(new TopComponent[arrayList.size()]);
    }
}

