/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types.visitor;

import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitor;
import java.util.ArrayList;
import java.util.List;

public final class CheckedVisitor
implements IVisitor {
    private final List<TypeDescriptor> m_checked = new ArrayList<TypeDescriptor>();
    private final List<TypeDescriptor> m_unChecked = new ArrayList<TypeDescriptor>();

    @Override
    public void visit(TypeFolder folder) {
        for (IVisitable v : folder.getChildren()) {
            v.accept(this);
        }
    }

    @Override
    public void visit(TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isChecked()) {
            this.m_checked.add(typeDescriptor);
        } else {
            this.m_unChecked.add(typeDescriptor);
        }
    }

    public List<TypeDescriptor> getChecked() {
        return this.m_checked;
    }

    public List<TypeDescriptor> getUnChecked() {
        return this.m_unChecked;
    }

    public List<TypeDescriptor> getAll() {
        ArrayList<TypeDescriptor> all = new ArrayList<TypeDescriptor>();
        all.addAll(this.m_checked);
        all.addAll(this.m_unChecked);
        return all;
    }
}

