/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.PointerType;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.ui.HistoryComboBox;
import sun.jvm.hotspot.ui.SAListener;
import sun.jvm.hotspot.ui.SAPanel;
import sun.jvm.hotspot.ui.tree.CTypeTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.OopTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeModel;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;
import sun.jvm.hotspot.utilities.CPPExpressions;
import sun.jvm.hotspot.utilities.LivenessAnalysis;
import sun.jvm.hotspot.utilities.LivenessPathList;
import sun.jvm.hotspot.utilities.ReversePtrsAnalysis;
import sun.jvm.hotspot.utilities.RobustOopDeterminator;
import sun.jvm.hotspot.utilities.WorkerThread;

public class Inspector
extends SAPanel {
    private JTree tree;
    private SimpleTreeModel model = new SimpleTreeModel();
    private HistoryComboBox addressField;
    private JLabel statusLabel;
    private JButton livenessButton;
    private ActionListener livenessButtonListener;
    private ActionListener showLivenessListener;
    private static final String computeLivenessText = "Compute Liveness";
    private static final String showLivenessText = "Show Liveness";
    private JLabel liveStatus;
    private LivenessPathList list = null;
    private Oop currentOop = null;

    public Inspector() {
        this.tree = new JTree(this.model);
        this.setLayout(new BorderLayout());
        Box hbox = Box.createHorizontalBox();
        JButton button = new JButton("Previous Oop");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = Inspector.this.addressField.getText();
                try {
                    VM vm = VM.getVM();
                    Address a = vm.getDebugger().parseAddress(text);
                    OopHandle handle = a.addOffsetToAsOopHandle(-vm.getAddressSize());
                    Inspector.this.addressField.setText(handle.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        hbox.add(button);
        hbox.add(new JLabel("Address / C++ Expression: "));
        this.addressField = new HistoryComboBox();
        hbox.add(this.addressField);
        this.statusLabel = new JLabel();
        hbox.add(this.statusLabel);
        Box hboxDown = Box.createHorizontalBox();
        hboxDown.add(Box.createGlue());
        this.livenessButton = new JButton(computeLivenessText);
        this.livenessButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Inspector.this.currentOop != null) {
                    Inspector.this.fireComputeLiveness();
                }
            }
        };
        this.showLivenessListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.fireShowLiveness();
            }
        };
        this.livenessButton.addActionListener(this.livenessButtonListener);
        hboxDown.add(this.livenessButton);
        hboxDown.add(Box.createGlue());
        this.liveStatus = new JLabel();
        hboxDown.add(this.liveStatus);
        hboxDown.add(Box.createGlue());
        this.add((Component)hbox, "North");
        this.add((Component)hboxDown, "South");
        this.addressField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = Inspector.this.addressField.getText();
                try {
                    Address a = VM.getVM().getDebugger().parseAddress(text);
                    int max_searches = 1000;
                    int searches = 0;
                    int offset = 0;
                    Oop oop = null;
                    if (a != null) {
                        OopHandle handle = a.addOffsetToAsOopHandle(0L);
                        while (searches < max_searches) {
                            ++searches;
                            if (RobustOopDeterminator.oopLooksValid(handle)) {
                                try {
                                    oop = VM.getVM().getObjectHeap().newOop(handle);
                                    Inspector.this.addressField.setText(handle.toString());
                                    break;
                                }
                                catch (UnknownOopException ex) {
                                }
                                catch (RuntimeException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            handle = a.addOffsetToAsOopHandle(offset -= 4);
                        }
                    }
                    if (oop != Inspector.this.currentOop) {
                        Inspector.this.currentOop = oop;
                        Inspector.this.liveStatus.setText("");
                        Inspector.this.list = null;
                        if (Inspector.this.livenessButton.getText().equals(Inspector.showLivenessText)) {
                            Inspector.this.livenessButton.setText(Inspector.computeLivenessText);
                            Inspector.this.livenessButton.removeActionListener(Inspector.this.showLivenessListener);
                            Inspector.this.livenessButton.addActionListener(Inspector.this.livenessButtonListener);
                        }
                    }
                    if (oop != null) {
                        Inspector.this.statusLabel.setText("");
                        Inspector.this.setRoot(new OopTreeNodeAdapter(oop, null));
                        return;
                    }
                    Type t = VM.getVM().getTypeDataBase().guessTypeForAddress(a);
                    if (t != null) {
                        Inspector.this.statusLabel.setText("");
                        Inspector.this.setRoot(new CTypeTreeNodeAdapter(a, t, null));
                        return;
                    }
                    Inspector.this.statusLabel.setText("<bad oop or unknown C++ object " + text + ">");
                }
                catch (NumberFormatException ex) {
                    CPPExpressions.CastExpr cast;
                    Inspector.this.currentOop = null;
                    Inspector.this.liveStatus.setText("");
                    Inspector.this.list = null;
                    if (Inspector.this.livenessButton.getText().equals(Inspector.showLivenessText)) {
                        Inspector.this.livenessButton.setText(Inspector.computeLivenessText);
                        Inspector.this.livenessButton.removeActionListener(Inspector.this.showLivenessListener);
                        Inspector.this.livenessButton.addActionListener(Inspector.this.livenessButtonListener);
                    }
                    if ((cast = CPPExpressions.parseCast(text)) != null) {
                        TypeDataBase db = VM.getVM().getTypeDataBase();
                        Type t = db.lookupType(cast.getType());
                        if (t == null) {
                            Inspector.this.statusLabel.setText("<unknown C++ type \"" + cast.getType() + "\">");
                        } else {
                            try {
                                Address a = VM.getVM().getDebugger().parseAddress(cast.getAddress());
                                Inspector.this.statusLabel.setText("");
                                Inspector.this.setRoot(new CTypeTreeNodeAdapter(a, t, null));
                            }
                            catch (NumberFormatException ex2) {
                                Inspector.this.statusLabel.setText("<bad address " + cast.getAddress() + ">");
                            }
                        }
                        return;
                    }
                    CPPExpressions.StaticFieldExpr stat = CPPExpressions.parseStaticField(text);
                    if (stat != null) {
                        TypeDataBase db = VM.getVM().getTypeDataBase();
                        Type t = db.lookupType(stat.getContainingType());
                        if (t == null) {
                            Inspector.this.statusLabel.setText("<unknown C++ type \"" + stat.getContainingType() + "\">");
                        } else {
                            Field f = t.getField(stat.getFieldName(), true, false);
                            if (f == null) {
                                Inspector.this.statusLabel.setText("<unknown field \"" + stat.getFieldName() + "\" in type \"" + stat.getContainingType() + "\">");
                            } else if (!f.isStatic()) {
                                Inspector.this.statusLabel.setText("<field \"" + stat.getContainingType() + "::" + stat.getFieldName() + "\" was not static>");
                            } else {
                                Type fieldType = f.getType();
                                if (fieldType.isPointerType()) {
                                    fieldType = ((PointerType)fieldType).getTargetType();
                                    Type typeGuess = db.guessTypeForAddress(f.getAddress());
                                    if (typeGuess != null) {
                                        fieldType = typeGuess;
                                    }
                                    Inspector.this.statusLabel.setText("");
                                    Inspector.this.setRoot(new CTypeTreeNodeAdapter(f.getAddress(), fieldType, new NamedFieldIdentifier(text)));
                                } else {
                                    Inspector.this.statusLabel.setText("");
                                    Inspector.this.setRoot(new CTypeTreeNodeAdapter(f.getStaticFieldAddress(), f.getType(), new NamedFieldIdentifier(text)));
                                }
                            }
                        }
                        return;
                    }
                    Inspector.this.statusLabel.setText("<parse error>");
                }
                catch (AddressException ex) {
                    ex.printStackTrace();
                    Inspector.this.currentOop = null;
                    Inspector.this.liveStatus.setText("");
                    Inspector.this.list = null;
                    if (Inspector.this.livenessButton.getText().equals(Inspector.showLivenessText)) {
                        Inspector.this.livenessButton.setText(Inspector.computeLivenessText);
                        Inspector.this.livenessButton.removeActionListener(Inspector.this.showLivenessListener);
                        Inspector.this.livenessButton.addActionListener(Inspector.this.livenessButtonListener);
                    }
                    Inspector.this.statusLabel.setText("<bad address>");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Inspector.this.currentOop = null;
                    Inspector.this.liveStatus.setText("");
                    Inspector.this.list = null;
                    if (Inspector.this.livenessButton.getText().equals(Inspector.showLivenessText)) {
                        Inspector.this.livenessButton.setText(Inspector.computeLivenessText);
                        Inspector.this.livenessButton.removeActionListener(Inspector.this.showLivenessListener);
                        Inspector.this.livenessButton.addActionListener(Inspector.this.livenessButtonListener);
                    }
                    Inspector.this.statusLabel.setText("<error constructing oop>");
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object node;
                int selRow = Inspector.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = Inspector.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1 && (e.getModifiersEx() & 0x40) != 0 && (node = Inspector.this.tree.getLastSelectedPathComponent()) != null && node instanceof SimpleTreeNode) {
                    Inspector.this.showInspector((SimpleTreeNode)node);
                }
            }
        };
        this.tree.addMouseListener(ml);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add((Component)scrollPane, "Center");
    }

    public Inspector(final SimpleTreeNode root) {
        this();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (root instanceof OopTreeNodeAdapter) {
                    Oop oop = ((OopTreeNodeAdapter)root).getOop();
                    Inspector.this.addressField.setText(oop.getHandle().toString());
                }
                Inspector.this.setRoot(root);
            }
        });
    }

    private void setRoot(SimpleTreeNode root) {
        this.model.setRoot(root);
    }

    private void fireComputeLiveness() {
        final Runnable cutoverButtonRunnable = new Runnable(){

            @Override
            public void run() {
                Inspector.this.list = LivenessAnalysis.computeAllLivenessPaths(Inspector.this.currentOop);
                if (Inspector.this.list == null) {
                    Inspector.this.liveStatus.setText("Oop is Dead");
                } else {
                    Inspector.this.liveStatus.setText("Oop is Alive");
                    Inspector.this.livenessButton.removeActionListener(Inspector.this.livenessButtonListener);
                    Inspector.this.livenessButton.addActionListener(Inspector.this.showLivenessListener);
                    Inspector.this.livenessButton.setEnabled(true);
                    Inspector.this.livenessButton.setText(Inspector.showLivenessText);
                }
            }
        };
        if (VM.getVM().getRevPtrs() != null) {
            cutoverButtonRunnable.run();
        } else {
            final WorkerThread worker = new WorkerThread();
            worker.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ReversePtrsAnalysis rev = new ReversePtrsAnalysis();
                        rev.run();
                        cutoverButtonRunnable.run();
                    }
                    finally {
                        worker.shutdown();
                    }
                }
            });
        }
    }

    private void fireShowLiveness() {
        if (this.list == null) {
            return;
        }
        for (SAListener listener : this.listeners) {
            listener.showLiveness(this.currentOop, this.list);
        }
    }
}

