/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.internal.FlightRecorderCommunicationHelper;
import com.jrockit.mc.rjmx.services.flr.internal.FlightRecorderService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.Level;

public final class FLRRecordingInputStream
extends InputStream {
    private static final String OPEN_STREAM = "openStream";
    private static final String READ_STREAM = "readStream";
    private static final String CLOSE_STREAM = "closeStream";
    private static final Long UNKNOWN_STREAM = -1L;
    private final IRecordingDescriptor recording;
    private final FlightRecorderCommunicationHelper helper;
    private byte[] buf = new byte[0];
    private int count = 0;
    private int pos = 0;
    private boolean closed = false;
    private boolean endOfStream = false;
    private boolean removeOnClose = true;
    private final Date startTime;
    private final Date endTime;
    private Long streamIdentifier = UNKNOWN_STREAM;

    public FLRRecordingInputStream(FlightRecorderCommunicationHelper helper, IRecordingDescriptor recording, Date startTime, Date endTime, boolean removeOnClose) {
        this.recording = recording;
        this.helper = helper;
        this.startTime = startTime;
        this.endTime = endTime;
        this.removeOnClose = removeOnClose;
        FlightRecorderService.LOGGER.log(Level.INFO, "Attempting to open stream from " + recording + " between " + startTime + " to " + endTime);
    }

    public FLRRecordingInputStream(FlightRecorderCommunicationHelper helper, IRecordingDescriptor recording, boolean removeOnClose) {
        this(helper, recording, null, null, removeOnClose);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos >= this.buf.length) {
            if (this.closed || this.endOfStream) {
                return -1;
            }
            this.fill();
            if (this.endOfStream) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private void fill() throws IOException {
        if (UNKNOWN_STREAM.equals(this.streamIdentifier)) {
            this.readStreamIdentifier();
        }
        this.buf = this.readStream(this.streamIdentifier);
        if (this.buf != null) {
            this.count += this.buf.length;
            this.pos = 0;
        } else {
            this.pos = 0;
            this.count = 0;
            this.buf = new byte[0];
            this.endOfStream = true;
        }
    }

    private void readStreamIdentifier() throws IOException {
        this.streamIdentifier = this.startTime == null ? this.openStream(this.recording) : this.openStream(this.recording, this.startTime, this.endTime);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!UNKNOWN_STREAM.equals(this.streamIdentifier)) {
            this.closeStream(this.streamIdentifier);
        }
        if (this.removeOnClose) {
            try {
                this.helper.closeRecording(this.recording);
            }
            catch (FlightRecorderException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private void closeStream(Long streamIdentifier) throws IOException {
        this.invokeOperation(CLOSE_STREAM, new Object[]{streamIdentifier});
    }

    private byte[] readStream(Long streamIdentifier) throws IOException {
        return (byte[])this.invokeOperation(READ_STREAM, new Object[]{streamIdentifier});
    }

    private Long openStream(IRecordingDescriptor descriptor) throws IOException {
        Long streamId = (Long)this.invokeOperation(OPEN_STREAM, new Object[]{descriptor.getObjectName()});
        if (streamId == null) {
            return UNKNOWN_STREAM;
        }
        return streamId;
    }

    private Long openStream(IRecordingDescriptor descriptor, Date startTime, Date endTime) throws IOException {
        Long streamId = (Long)this.invokeOperation(OPEN_STREAM, new Object[]{descriptor.getObjectName(), startTime, endTime});
        if (streamId == null) {
            return UNKNOWN_STREAM;
        }
        return streamId;
    }

    private Object invokeOperation(String name, Object[] params) throws IOException {
        try {
            return this.helper.invokeOperation(name, params);
        }
        catch (Exception ioe) {
            FlightRecorderService.LOGGER.info("Failed to invoke operation " + name + ". Will now close! Message was: " + ioe.getMessage());
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOException iot = new IOException(ioe.getLocalizedMessage());
            iot.initCause(ioe);
            throw iot;
        }
    }
}

