/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.configuration.spi.IStorageProvider;
import com.jrockit.mc.flightrecorder.configuration.spi.ITemplateStorageDelegate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.PrivateStorageDelegate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.VolatileStorageDelegate;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class TemplateRepositoryFactory {
    private static final String EXTENSION_POINT = "com.jrockit.mc.flightrecorder.configuration.storageProvider";
    private static final String EXTENSION_ATTRIBUTE_CLASS = "class";
    private static final String LOWER_CASE_FILE_EXTENSION = ".jfc".toLowerCase();
    private static final String LAST_STARTED_CONFIGURATION_FILE_NAME = "last_started_configuration" + LOWER_CASE_FILE_EXTENSION;
    static final File TEMPLATE_STORAGE_DIR = ControlPanel.getDefault().getStateLocation().append(".rectemplates").toFile();

    public static RecordingTemplateRepository create() {
        RecordingTemplateRepository repository = new RecordingTemplateRepository();
        TemplateRepositoryFactory.initiate(repository);
        return repository;
    }

    protected static void initiate(RecordingTemplateRepository repository) {
        TemplateRepositoryFactory.addLocalTemplatesTo(repository);
        TemplateRepositoryFactory.addContributedTemplatesTo(repository);
        repository.notifyObservers();
    }

    private static void addLocalTemplatesTo(RecordingTemplateRepository repository) {
        File localDir = TEMPLATE_STORAGE_DIR;
        if (!localDir.isDirectory()) {
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(LOWER_CASE_FILE_EXTENSION);
            }
        };
        File[] fileArray = localDir.listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.length() != 0L) {
                try {
                    RecordingTemplate template;
                    if (file.getName().equalsIgnoreCase(LAST_STARTED_CONFIGURATION_FILE_NAME)) {
                        XMLModel model = RecordingTemplate.createModel(file);
                        template = new RecordingTemplate(model, VolatileStorageDelegate.getLastStartedDelegate());
                    } else {
                        PrivateStorageDelegate delegate = new PrivateStorageDelegate(file);
                        template = new RecordingTemplate(delegate);
                    }
                    repository.add(template);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private static void addContributedTemplatesTo(RecordingTemplateRepository repository) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IStorageProvider provider = (IStorageProvider)element.createExecutableExtension(EXTENSION_ATTRIBUTE_CLASS);
                for (ITemplateStorageDelegate delegate : provider.getStorageDelegates(LOWER_CASE_FILE_EXTENSION)) {
                    try {
                        RecordingTemplate template = new RecordingTemplate(delegate);
                        repository.add(template);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static File getCreatedStorageDir() throws IOException {
        File dir = TEMPLATE_STORAGE_DIR;
        if (!dir.isDirectory() && !dir.mkdir()) {
            throw new IOException("Could not create the directory " + dir.toString());
        }
        return dir;
    }

    public static void saveAsLastStarted(IRecordingConfiguration configuration) {
        try {
            File file = new File(TemplateRepositoryFactory.getCreatedStorageDir(), LAST_STARTED_CONFIGURATION_FILE_NAME);
            configuration.exportToFile(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

